/*
 * Decompiled with CFR 0.152.
 */
package mobac.mapsources.mappacks.openstreetmap;

import java.io.IOException;
import mobac.exceptions.TileException;
import mobac.mapsources.mappacks.openstreetmap.AbstractOsmMapSource;
import mobac.program.interfaces.MapSource;
import mobac.program.model.Settings;

public class WanderreitkarteAbo
extends AbstractOsmMapSource {
    public static final String ABO = "http://abo.wanderreitkarte.de";

    public WanderreitkarteAbo() {
        super("WanderreitkarteAbo");
        this.minZoom = 2;
        this.maxZoom = 16;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getTileData(int zoom, int x, int y, MapSource.LoadMethod loadMethod) throws IOException, TileException, InterruptedException {
        if (loadMethod == MapSource.LoadMethod.CACHE) {
            return super.getTileData(zoom, x, y, loadMethod);
        }
        WanderreitkarteAbo wanderreitkarteAbo = this;
        synchronized (wanderreitkarteAbo) {
            return super.getTileData(zoom, x, y, loadMethod);
        }
    }

    @Override
    public String getTileUrl(int zoom, int tilex, int tiley) {
        String ticket = Settings.getInstance().osmHikingTicket;
        if (ticket != null && ticket.length() > 0) {
            return ABO + super.getTileUrl(zoom, tilex, tiley) + "/ticket/" + ticket;
        }
        return null;
    }

    public String toString() {
        return "Reit- und Wanderkarte ($Abo)";
    }
}

