/*
 * Decompiled with CFR 0.152.
 */
package mobac.mapsources.mappacks.openstreetmap;

import java.io.IOException;
import mobac.exceptions.DownloadFailedException;
import mobac.exceptions.StopAllDownloadsException;
import mobac.exceptions.TileException;
import mobac.mapsources.AbstractMultiLayerMapSource;
import mobac.mapsources.mappacks.openstreetmap.AbstractOsmMapSource;
import mobac.mapsources.mappacks.openstreetmap.Mapnik;
import mobac.program.interfaces.HttpMapSource;
import mobac.program.interfaces.MapSource;
import mobac.program.interfaces.MapSourceTextAttribution;
import mobac.program.model.TileImageType;

public class OpenPisteMap
extends AbstractMultiLayerMapSource
implements MapSourceTextAttribution {
    private static final String BASE = "http://tiles.openpistemap.org/nocontours";
    private static final String LAMDSHED = "http://tiles2.openpistemap.org/landshaded";

    public OpenPisteMap() {
        super("OpenPisteMapBCL", TileImageType.PNG);
        this.mapSources = new MapSource[]{new Mapnik(), new OpenPisteMapBase(), new OpenPisteMapLandshed()};
        this.initializeValues();
    }

    public String toString() {
        return "Open Piste Map";
    }

    public String getAttributionText() {
        return "\u00a9 OpenStreetMap contributors, CC-BY-SA";
    }

    public String getAttributionLinkURL() {
        return "http://openstreetmap.org";
    }

    public static class OpenPisteMapLandshed
    extends AbstractOpenPisteMap {
        public OpenPisteMapLandshed() {
            super("OpenPisteMapLandshed");
            this.maxZoom = 17;
            this.tileUpdate = HttpMapSource.TileUpdate.LastModified;
        }

        public String toString() {
            return "Open Piste Landshed Layer";
        }

        @Override
        public String getTileUrl(int zoom, int tilex, int tiley) {
            return OpenPisteMap.LAMDSHED + super.getTileUrl(zoom, tilex, tiley);
        }
    }

    public static class OpenPisteMapBase
    extends AbstractOpenPisteMap {
        public OpenPisteMapBase() {
            super("OpenPisteMap");
            this.maxZoom = 17;
            this.tileUpdate = HttpMapSource.TileUpdate.LastModified;
        }

        public String toString() {
            return "Open Piste Contours Layer";
        }

        @Override
        public String getTileUrl(int zoom, int tilex, int tiley) {
            return OpenPisteMap.BASE + super.getTileUrl(zoom, tilex, tiley);
        }
    }

    public static abstract class AbstractOpenPisteMap
    extends AbstractOsmMapSource {
        public AbstractOpenPisteMap(String name) {
            super(name);
        }

        public byte[] getTileData(int zoom, int x, int y, MapSource.LoadMethod loadMethod) throws IOException, TileException, InterruptedException {
            try {
                return super.getTileData(zoom, x, y, loadMethod);
            }
            catch (DownloadFailedException e) {
                if (e.getHttpResponseCode() == 403) {
                    throw new StopAllDownloadsException("Server blocks mass download - aborting map dowload", (Throwable)e);
                }
                throw e;
            }
        }
    }
}

